
"""
---------------------------------
READ REPORTED DATA
---------------------------------

"""
import csv
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt


def read_single_row_csv_as_ints(filename):
    """
    Reads a single-row CSV and converts the values to integers.
    """
    with open(filename, 'r', newline='') as file:
        reader = csv.reader(file)
        try:
            row = next(reader)
            # Use a list comprehension to convert each string to an integer
            return [int(val) for val in row]
        except (StopIteration, ValueError) as e:
            print(f"An error occurred: {e}")
            return []

def read_single_column_csv_as_ints(filename):
    """
    Reads a single-column CSV and converts the values to integers.
    """
    data_list = []
    with open(filename, 'r') as file:
      reader = csv.reader(file)
      for row in reader:
        data_list.append(row[0])
      return [int(val) for val in data_list]


def moving_average(data, window_size):
    """
    Calculates the moving average of an array using NumPy's convolve function.

    Args:
        data (np.array): The input array of numerical data.
        window_size (int): The number of neighbors to average.

    Returns:
        np.array: The array with the moving average applied.
    """
    # Create an array of ones to use as a window filter
    weights = np.ones(window_size) / window_size

    return np.convolve(data, weights, mode='valid')

detrate=1/10


# read actual values
!wget -O nacion.csv https://fceia.unr.edu.ar/~kofman/files/nacion.csv
Pop=45e6
data_read = read_single_column_csv_as_ints('nacion.csv')
data=[x / (Pop*detrate) for x in data_read[100:340]]
data2=[x  for x in data_read[100:340]]

filt_data=moving_average(data,7)
filt_data2=moving_average(data2,7)

#plot actual values
plt.figure(figsize=(10, 6))

plt.plot(data2)
plt.plot(filt_data2)
T=len(filt_data)
plt.title('Real Data')

"""
-----------------------
AGGREGATED MODEL VS REAL DATA
-----------------------

"""
import numpy as np
import matplotlib.pyplot as plt
from scipy.optimize import root_scalar

from scipy.integrate import odeint

def eqRinf(Rinf):
        return Rinf - (1 - np.exp(-beta/gamma * Rinf))

def pSIR_model(x,t,rho,betar,alpha,beta,gamma):
    pI, pR, S, I, R = x

    pS = N - pI - pR

    dpR_dt = betar/Sinf *R*S/pI;
    dpS_dt = -rho * I *np.arctan(alpha * pS/N * np.pi/2) * 2/np.pi
    dpI_dt = -dpR_dt-dpS_dt;

    dS_dt = -dpS_dt- beta * I * S/pI - Sinf*dpR_dt;
    dI_dt = beta * I * S / pI - gamma * I;
    dR_dt = gamma*I - Rinf * dpR_dt;
    return [dpI_dt,dpR_dt,dS_dt, dI_dt, dR_dt]

def get_simulated_results(time_points,pI_0,rho,betar,alpha,beta,gamma):


  # Initial conditions
  I_0 = filt_data[1]/beta     # Initial infected population
  S_0 = pI_0-I_0  # Initial susceptible population (exposed)
  R_0 = 0      # Initial recovered population
  pR_0 = 0
  x0 = [pI_0, pR_0, S_0, I_0, R_0]
  Rinfresult = root_scalar(eqRinf, x0=0.5, method='newton', bracket=[0, 1])
  Rinf=Rinfresult.root

  #solution
  sol = odeint(pSIR_model, x0, time_points,rtol=1e-9, atol=1e-12,args=(rho,betar,alpha,beta,gamma))
  S = sol[:, 2]
  I = sol[:, 3]
  R = sol[:, 4]
  C = beta * I * S / (S+I+R)
  return C


# Parameters

N=1

rho =  0.8026
betar =  0.01911
alpha =  242.4
beta =  0.2118
gamma =  0.1667
pI_0 =  0.1796

# Time solution
t_start = 0.0
t_end = T-1
num_points = T
time_points = np.linspace(t_start, t_end, num_points)

#solution
Ctest=get_simulated_results(time_points,pI_0,rho,betar,alpha,beta,gamma)


plt.figure(figsize=(10, 6))
plt.plot(time_points, Ctest * Pop * detrate , label='Simulated Cases')
plt.plot(time_points, filt_data * Pop * detrate, label='Reported Cases')
plt.title('Aggregated Model vs. Real Data')
plt.xlabel('Time')
plt.ylabel('Daily Cases')
plt.grid(True)
plt.legend()
plt.savefig("fitting.svg")
plt.show()

#-----------------------------------

